CREATE SCHEMA IF NOT EXISTS TCad;

CREATE TABLE IF NOT EXISTS TCad.PathPart(
    pp_id    SERIAL PRIMARY KEY,
    pp_dtid    VARCHAR(30) NOT NULL,
    pp_group    SMALLINT NOT NULL,
    pp_value    VARCHAR(200) NOT NULL,
    pp_adkrz    VARCHAR(21) NOT NULL
);

CREATE TABLE IF NOT EXISTS TCad.CadDocTypes (
    cdt_id    SERIAL PRIMARY KEY,
    cdt_dtid    VARCHAR(30)  NOT NULL,
    cdt_type    VARCHAR(10) NOT NULL,
    cdt_pfx    VARCHAR(10),
    cdt_sfx    VARCHAR(10),
    cdt_fn    VARCHAR(100) NOT NULL
);

-- Dynamischer Sync
CREATE TABLE TCad.CADSyncItems(
  csi_id            SERIAL PRIMARY KEY,
  csi_item          VARCHAR(100) NOT NULL,
  csi_autosync      BOOLEAN NOT NULL DEFAULT TRUE,
  csi_whencheckout  BOOLEAN NOT NULL DEFAULT TRUE,
  csi_whencheckin   BOOLEAN NOT NULL DEFAULT TRUE,
  csi_whenprepared  BOOLEAN NOT NULL DEFAULT TRUE,
  csi_whenchecked   BOOLEAN NOT NULL DEFAULT TRUE,
  csi_whenapproved  BOOLEAN NOT NULL DEFAULT TRUE
);

CREATE UNIQUE INDEX CADSyncItems_item ON TCad.CADSyncItems (csi_item);